@extends('admin.layout.page-app')
@section('page_title', __('label.add_contest'))
@section('tab_title', __('label.add_contest'))

@section('content')
	@include('admin.layout.sidebar')

	<div class="right-content">
		@include('admin.layout.header')

		<div class="body-content">
			<!-- mobile title -->
			<h1 class="page-title-sm">{{__('label.add_contest')}}</h1>

			<div class="border-bottom row">
				<div class="col-sm-10">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
						<li class="breadcrumb-item"><a href="{{ route('admin.contests.index') }}">{{__('label.contests')}}</a></li>
						<li class="breadcrumb-item active" aria-current="page">{{__('label.add_contest')}}</li>
					</ol>
				</div>
				<div class="col-sm-2 d-flex align-items-center justify-content-end">
					<a href="{{ route('admin.contests.index') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('label.contests')}}</a>
				</div>
			</div>

			<div class="card custom-border-card mt-3">
				<form id="save_contest" enctype="multipart/form-data">
					<input type="hidden" name="id" value="">
					<div class="form-row">
						<div class="col-md-9">
							<div class="form-row">
								<div class="col-md-8">
									<div class="form-group">
										<label>{{__('label.name')}}<span class="text-danger">*</span></label>
										<input name="name" type="text" class="form-control" placeholder="{{__('label.name_here')}}" autofocus>
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group">
										<label>{{__('label.entry_fee')}}<span class="text-danger">*</span></label>
										<input name="entry_fee" type="number" class="form-control" min="1" placeholder="{{__('label.entry_fee_here')}}">
									</div>
								</div>
							</div>
							<div class="form-row">
								<div class="col-md-4">
									<div class="form-group">
										<label>{{__('label.start_date')}}<span class="text-danger">*</span></label>
										<input name="start_date" type="date" class="form-control" min="{{ date('Y-m-d') }}">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group">
										<label>{{__('label.end_date')}}<span class="text-danger">*</span></label>
										<input name="end_date" type="date" class="form-control" min="{{ date('Y-m-d') }}">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group">
										<label>{{__('label.maximum_participants')}}<span class="text-danger">*</span></label>
										<input name="max_participants" type="number" class="form-control" min="1" placeholder="{{__('label.maximum_participants_here')}}">
									</div>
								</div>
							</div>
							<div class="form-row">
								<div class="col-md-4">
									<div class="form-group">
										<label>{{__('label.user_total_prize')}}<span class="text-danger">*</span></label>
										<input name="total_prize_users" type="number" class="form-control" min="0" placeholder="{{__('label.user_total_prize_here')}}">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group">
										<label>{{__('label.total_ranks')}}<span class="text-danger">*</span></label>
										<input name="total_ranks" type="number" class="form-control" min="0" placeholder="{{__('label.total_ranks_here')}}">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group">
										<label>{{__('label.total_prize_coins')}}<span class="text-danger">*</span></label>
										<input name="total_prize_coins" type="number" class="form-control" min="0" placeholder="{{__('label.total_prize_coins_here')}}">
									</div>
								</div>
							</div>
							<div class="form-row">
								<div class="col-md-4">
									<div class="form-group">
										<label>{{__('label.total_questions')}}<span class="text-danger">*</span></label>
										<input name="total_questions" type="number" class="form-control" min="0" placeholder="{{__('label.total_questions_here')}}">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group">
										<label>{{__('label.duration_per_question')}}<span class="text-danger">*</span></label>
										<input type="number" name="duration" min="1" class="form-control" placeholder="{{__('label.seconds_here')}}">
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-3">
							<div class="form-group ml-5">
								<label>{{__('label.image')}}<span class="text-danger">*</span></label>
								<div class="avatar-upload">
									<div class="avatar-edit">
										<input type='file' name="image" id="imageUpload1" accept=".png, .jpg, .jpeg" />
										<label for="imageUpload1" title="{{__('label.upload_file')}}"></label>
									</div>
									<div class="avatar-preview">
										<img src="{{ asset('assets/imgs/upload_img.png') }}" id="imagePreview1">
									</div>
								</div>
								<label class="mt-3 text-gray">{{__('label.max_size_5mb')}}</label>
							</div>
						</div>
					</div>
					<div class="border-top pt-3 text-right">
						<button type="button" class="btn btn-default mw-120" onclick="save_contest()">{{__('label.save')}}</button>
						<a href="{{ route('admin.contests.index') }}" class="btn btn-cancel mw-120 ml-2">{{__('label.cancel')}}</a>
						<input type="hidden" name="_token" value="{{ csrf_token() }}">
					</div>
				</form>
			</div>
		</div>
	</div>
@endsection

@section('pagescript')
	<script>
		function save_contest(){

			var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

				$("#dvloader").show();
				var formData = new FormData($("#save_contest")[0]);
				$.ajax({
					type:'POST',
					url:'{{ route("admin.contests.store") }}',
					data:formData,
					cache:false,
					contentType: false,
					processData: false,
					success:function(resp){
						$("#dvloader").hide();
						get_responce_message(resp, 'save_contest', '{{ route("admin.contests.index") }}');
					},
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
				});
			} else {
                showError();
            }
		}
	</script>
@endsection